/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalUpdateStatus;
import org.sonarsource.sonarlint.core.client.api.connected.ModuleUpdateStatus;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.proto.Sonarlint;

public class StorageManager {
    public static final String PLUGIN_REFERENCES_PB = "plugin_references.pb";
    public static final String PROPERTIES_PB = "properties.pb";
    public static final String MODULE_CONFIGURATION_PB = "configuration.pb";
    public static final String RULES_PB = "rules.pb";
    public static final String UPDATE_STATUS_PB = "update_status.pb";
    public static final String SERVER_INFO_PB = "server_info.pb";
    public static final String ACTIVE_RULES_FOLDER = "active_rules";
    public static final String MODULE_LIST_PB = "module_list.pb";
    private final Path serverStorageRoot;
    private final Path globalStorageRoot;
    private final Path moduleStorageRoot;
    private final GlobalUpdateStatus updateStatus;

    public StorageManager(ConnectedGlobalConfiguration configuration) {
        this.serverStorageRoot = configuration.getStorageRoot().resolve(configuration.getServerId());
        this.globalStorageRoot = this.serverStorageRoot.resolve("global");
        this.moduleStorageRoot = this.serverStorageRoot.resolve("modules");
        this.updateStatus = this.initUpdateStatus();
    }

    public Path getServerStorageRoot() {
        return this.serverStorageRoot;
    }

    public Path getGlobalStorageRoot() {
        return this.globalStorageRoot;
    }

    public Path getModuleStorageRoot(String moduleKey) {
        return this.moduleStorageRoot.resolve(StorageManager.encodeForFs(moduleKey));
    }

    private static String encodeForFs(String moduleKey) {
        try {
            return URLEncoder.encode(moduleKey, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to encode module key", e);
        }
    }

    public Path getModuleConfigurationPath(String moduleKey) {
        return this.getModuleStorageRoot(moduleKey).resolve(MODULE_CONFIGURATION_PB);
    }

    public Path getModuleUpdateStatusPath(String moduleKey) {
        return this.getModuleStorageRoot(moduleKey).resolve(UPDATE_STATUS_PB);
    }

    public Path getPluginReferencesPath() {
        return this.getGlobalStorageRoot().resolve(PLUGIN_REFERENCES_PB);
    }

    public Path getGlobalPropertiesPath() {
        return this.getGlobalStorageRoot().resolve(PROPERTIES_PB);
    }

    public Path getModuleListPath() {
        return this.getGlobalStorageRoot().resolve(MODULE_LIST_PB);
    }

    public Path getRulesPath() {
        return this.getGlobalStorageRoot().resolve(RULES_PB);
    }

    public Path getActiveRulesPath(String qProfileKey) {
        return this.getGlobalStorageRoot().resolve(ACTIVE_RULES_FOLDER).resolve(qProfileKey + ".pb");
    }

    public Path getUpdateStatusPath() {
        return this.getGlobalStorageRoot().resolve(UPDATE_STATUS_PB);
    }

    public Path getServerInfoPath() {
        return this.getGlobalStorageRoot().resolve(SERVER_INFO_PB);
    }

    @CheckForNull
    public GlobalUpdateStatus getGlobalUpdateStatus() {
        return this.updateStatus;
    }

    @CheckForNull
    private GlobalUpdateStatus initUpdateStatus() {
        Path updateStatusPath = this.getUpdateStatusPath();
        if (Files.exists(updateStatusPath, new LinkOption[0])) {
            final Sonarlint.UpdateStatus updateStatusFromStorage = ProtobufUtil.readFile(updateStatusPath, Sonarlint.UpdateStatus.parser());
            final Sonarlint.ServerInfos serverInfoFromStorage = ProtobufUtil.readFile(this.getServerInfoPath(), Sonarlint.ServerInfos.parser());
            return new GlobalUpdateStatus(){

                public String getServerVersion() {
                    return serverInfoFromStorage.getVersion();
                }

                public Date getLastUpdateDate() {
                    return new Date(updateStatusFromStorage.getUpdateTimestamp());
                }
            };
        }
        return null;
    }

    public Sonarlint.Rules readRulesFromStorage() {
        return ProtobufUtil.readFile(this.getRulesPath(), Sonarlint.Rules.parser());
    }

    public Sonarlint.GlobalProperties readGlobalPropertiesFromStorage() {
        return ProtobufUtil.readFile(this.getGlobalPropertiesPath(), Sonarlint.GlobalProperties.parser());
    }

    public Sonarlint.ModuleConfiguration readModuleConfigFromStorage(String moduleKey) {
        return ProtobufUtil.readFile(this.getModuleConfigurationPath(moduleKey), Sonarlint.ModuleConfiguration.parser());
    }

    public ModuleUpdateStatus getModuleUpdateStatus(String moduleKey) {
        Path updateStatusPath = this.getModuleUpdateStatusPath(moduleKey);
        if (Files.exists(updateStatusPath, new LinkOption[0])) {
            final Sonarlint.UpdateStatus updateStatusFromStorage = ProtobufUtil.readFile(updateStatusPath, Sonarlint.UpdateStatus.parser());
            return new ModuleUpdateStatus(){

                public Date getLastUpdateDate() {
                    return new Date(updateStatusFromStorage.getUpdateTimestamp());
                }
            };
        }
        return null;
    }

    public Sonarlint.ModuleList readModuleListFromStorage() {
        return ProtobufUtil.readFile(this.getModuleListPath(), Sonarlint.ModuleList.parser());
    }
}

